/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.data;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.molap.aggregates.cube.UnivariateStatistics;
import com.macrofocus.molap.dataframe.CombinedDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.ReIndexRecipe;
import com.macrofocus.molap.dataframe.ReIndexedDataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.molap.dataframe.java.JavaDataFrameFactory;
import com.macrofocus.molap.dataframe.matrix.CacheMatrix;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import matching.EqualMatcher;
import matching.Matcher;
import matching.MatchingDataFrame;
import matching.MatchingMatrix;
import matching.NumericalMatcher;

public class TestMatcher {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        try {
            MutableDataFrame dataFrame1 = JavaDataFrameFactory.fromCSV((URL)new File(args[0]).toURI().toURL());
            MutableDataFrame dataFrame2 = JavaDataFrameFactory.fromCSV((URL)new File(args[1]).toURI().toURL());
            dataFrame1.printSchema();
            System.out.println();
            dataFrame2.printSchema();
            MatchingDataFrame matchingDataFrame = new MatchingDataFrame((DataFrame)dataFrame1, (DataFrame)dataFrame2);
            UnivariateStatistics start_year = dataFrame1.getStatistics((Object)"start_year");
            UnivariateStatistics battle_year_start = dataFrame2.getStatistics((Object)"battle_year_start");
            double minYear = Math.min(start_year.getMinimum().doubleValue(), battle_year_start.getMinimum().doubleValue());
            double maxYear = Math.max(start_year.getMaximum().doubleValue(), battle_year_start.getMaximum().doubleValue());
            matchingDataFrame.addMatcher((Matcher)new EqualMatcher((DataFrame)dataFrame1, (DataFrame)dataFrame2, (Object)"start_year", (Object)"battle_year_start"));
            matchingDataFrame.addMatcher((Matcher)new NumericalMatcher((DataFrame)dataFrame1, (DataFrame)dataFrame2, (Object)"longitude", (Object)"battle_loc_long", (Number)-180, (Number)-180, (Number)180, (Number)180));
            matchingDataFrame.addMatcher((Matcher)new NumericalMatcher((DataFrame)dataFrame1, (DataFrame)dataFrame2, (Object)"latitude", (Object)"battle_loc_lat", (Number)-90, (Number)-90, (Number)90, (Number)90));
            MatchingMatrix matchingMatrix = new MatchingMatrix(matchingDataFrame);
            final CacheMatrix cacheMatrix = new CacheMatrix((Matrix)matchingMatrix);
            ArrayList<MatchingDataFrame.Pair> solution = new ArrayList<MatchingDataFrame.Pair>();
            HashSet rows = new HashSet(Iterables.makeCollection((Iterable)cacheMatrix.rows()));
            HashSet columns = new HashSet(Iterables.makeCollection((Iterable)cacheMatrix.columns()));
            int length = Math.min(rows.size(), columns.size());
            for (int i = 0; i < length; ++i) {
                void var19_19;
                double min = Double.MAX_VALUE;
                Object var19_20 = null;
                Integer startColumn = null;
                for (Integer row : rows) {
                    for (Integer column : columns) {
                        double value = cacheMatrix.getDouble((Object)row, (Object)column);
                        if (!(value < min)) continue;
                        min = value;
                        Integer n = row;
                        startColumn = column;
                    }
                }
                rows.remove(var19_19);
                columns.remove(startColumn);
                MatchingDataFrame.Pair pair = new MatchingDataFrame.Pair((Object)var19_19, startColumn);
                solution.add(pair);
                System.out.println(i + ": " + String.valueOf(pair.getR1()) + " -> " + String.valueOf(pair.getR2()));
            }
            ArrayList<MatchingDataFrame.Pair<Integer, Integer>> sorted = new ArrayList<MatchingDataFrame.Pair<Integer, Integer>>(solution);
            sorted.sort(new Comparator<MatchingDataFrame.Pair<Integer, Integer>>(){

                @Override
                public int compare(MatchingDataFrame.Pair<Integer, Integer> o1, MatchingDataFrame.Pair<Integer, Integer> o2) {
                    if (o1 != null && o1.getR1() != null) {
                        if (o2 != null && o2.getR1() != null) {
                            int i = ((Integer)o1.getR1()).compareTo((Integer)o2.getR1());
                            return i;
                        }
                        return 1;
                    }
                    return -1;
                }
            });
            final ArrayList<Integer> reindex = new ArrayList<Integer>();
            for (MatchingDataFrame.Pair pair : sorted) {
                reindex.add((Integer)pair.getR2());
            }
            WrappedDataFrame derivedDataFrame = new WrappedDataFrame((DataFrame)dataFrame1);
            derivedDataFrame.addOriginalColumns();
            derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DerivedColumn("Distance", Double.class){

                public Object getValue(WrappedDataFrame dataFrame, Object o) {
                    return cacheMatrix.getDouble((Object)((Integer)o), (Object)((Integer)reindex.get(dataFrame.getOriginalDataFrame().getRowAddress(o))));
                }
            }});
            for (String column : dataFrame2.columns()) {
                derivedDataFrame.addDerivedColumn(new WrappedDataFrame.Column[]{new WrappedDataFrame.DerivedColumn(dataFrame2.getColumnName((Object)column), dataFrame2.getColumnClass((Object)column), (DataFrame)dataFrame2, reindex, column){
                    final /* synthetic */ DataFrame val$dataFrame2;
                    final /* synthetic */ List val$reindex;
                    final /* synthetic */ String val$column;
                    {
                        this.val$dataFrame2 = dataFrame;
                        this.val$reindex = list;
                        this.val$column = string;
                        super(arg0, arg1);
                    }

                    public Object getValue(WrappedDataFrame dataFrame, Object o) {
                        return this.val$dataFrame2.getValueAt((Object)((Integer)this.val$reindex.get(dataFrame.getOriginalDataFrame().getRowAddress(o))), (Object)this.val$column);
                    }
                }});
            }
            SwingDataFrameExporter.exportCSV((DataFrame)derivedDataFrame, (File)new File("matching.csv"));
            SwingDataFrameExporter.exportExcelX((DataFrame)derivedDataFrame, (File)new File("matching.xlsx"));
            CombinedDataFrame combinedDataFrame = new CombinedDataFrame((DataFrame)dataFrame1, (DataFrame)new ReIndexedDataFrame((DataFrame)dataFrame2, (ReIndexRecipe)new ReIndexRecipe<Integer, String>(){
                final /* synthetic */ DataFrame val$dataFrame2;
                {
                    this.val$dataFrame2 = dataFrame;
                }

                public UniqueIndex<Integer> buildRowIndex() {
                    return new DefaultUniqueIndex(reindex);
                }

                public UniqueIndex<String> buildColumnIndex() {
                    return this.val$dataFrame2.getColumnIndex();
                }
            }), (CombinedDataFrame.CombinedRecipe)new CombinedDataFrame.LeftSemiJoinCombinedRecipe());
            combinedDataFrame.print();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

