/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document.swing;

import com.macrofocus.application.ActionUICommand;
import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ToggleActionToggleUICommand;
import com.macrofocus.application.ToggleUICommand;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.FullScreenCommand;
import com.macrofocus.application.high_d.configuration.swing.SwingDetails;
import com.macrofocus.application.high_d.configuration.swing.SwingHighDConfigurationPanel;
import com.macrofocus.application.high_d.document.AxesPanel;
import com.macrofocus.application.high_d.document.HighDConfigurationPanel;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.JavaHighDApplication;
import com.macrofocus.application.high_d.document.JavaHighDDocument;
import com.macrofocus.application.high_d.document.JavaHighDView;
import com.macrofocus.application.high_d.document.swing.ExportSettingsUICommand;
import com.macrofocus.application.high_d.document.swing.ImportSettingsUICommand;
import com.macrofocus.application.high_d.document.swing.SettingsFileChooserFactory;
import com.macrofocus.application.high_d.document.swing.SwingHighDApplication;
import com.macrofocus.application.high_d.document.swing.export.ExportDataAction;
import com.macrofocus.application.high_d.document.swing.export.ExportGraphicsAction;
import com.macrofocus.application.high_d.model.HighDModel;
import com.macrofocus.application.high_d.settings.SwingAxesPanel;
import com.macrofocus.application.high_d.swing.HighD;
import com.macrofocus.application.high_d.view.clustering.SwingClustering;
import com.macrofocus.application.high_d.view.regression.SwingRegression;
import com.macrofocus.application.menu.CPMenu;
import com.macrofocus.application.menu.CPMenuBar;
import com.macrofocus.application.menu.ToggleGroup;
import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.cartoplot.CartoPlot;
import com.macrofocus.cartoplot.CartoPlotModel;
import com.macrofocus.cartoplot.DefaultCartoPlotModel;
import com.macrofocus.cartoplot.georeferencing.GeoReferencingServiceFactory;
import com.macrofocus.cartoplot.swing.SwingCartoPlot;
import com.macrofocus.cartoplot.swing.SwingCartoPlotPanel;
import com.macrofocus.cartoplot.swing.georeferencing.SwingGeoReferencingServiceFactory;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.docking.AttachAnchor;
import com.macrofocus.docking.Dockable;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.docking.swing.SwingDockingFactory;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.clustering.Clustering;
import com.macrofocus.high_d.controlchart.ControlChart;
import com.macrofocus.high_d.details.Details;
import com.macrofocus.high_d.mds.MDS;
import com.macrofocus.high_d.mds.MDSPanel;
import com.macrofocus.high_d.mds.swing.SwingMDS;
import com.macrofocus.high_d.mds.swing.SwingMDSPanel;
import com.macrofocus.high_d.regression.Regression;
import com.macrofocus.high_d.scatterplot.ScatterPlot;
import com.macrofocus.high_d.scatterplot.ScatterPlotPanel;
import com.macrofocus.high_d.scatterplot.swing.SwingScatterPlot;
import com.macrofocus.high_d.scatterplot.swing.SwingScatterPlotPanel;
import com.macrofocus.high_d.swing.SwingHighDFactory;
import com.macrofocus.high_d.treemap.swing.SwingTreeMapPanel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.help.WebHelpAction;
import com.macrofocus.util.java2d.SimpleRenderingHintsModel;
import com.macrofocus.util.registration.LicenseHelper;
import com.macrofocus.util.registration.RegisterAction;
import com.macrofocus.util.swing.action.AboutAction;
import com.macrofocus.util.swing.action.ToggleAction;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.FileProvider;
import com.macrofocus.util.swing.plaf.action.LookAndFeelAction;
import com.macrofocus.util.swing.print.PageSetupAction;
import com.macrofocus.util.swing.print.PrintComponentAction;
import com.treemap.AbstractTreeMapNode;
import com.treemap.TreeMap;
import com.treemap.swing.table.SwingTableFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.Format;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SwingHighDView
extends JavaHighDView<JFrame, JComponent, Color, Font, Format> {
    private final SwingHighDApplication application;
    private final JFrame window;
    private final boolean expertMode;
    private ResourcesModel resourcesModel;
    private SimpleRenderingHintsModel renderingHintsModel;
    private SwingCartoPlot cartoPlot = null;
    private SwingHighDConfigurationPanel<Integer, String> configurationPanel;
    private SwingAxesPanel<Integer, String> axesPanel;
    private Dockable<JComponent> cartoPlotDockable;
    private AboutAction aboutAction;

    public SwingHighDView(SwingHighDApplication application, JFrame window, boolean expertMode, DocumentBasedApplicationProperties properties) {
        super(new SwingHighDFactory<Integer, String, Object>(){

            public Details<JComponent, Color, Integer, String> createDetails() {
                SwingDetails<Integer, String> details = new SwingDetails<Integer, String>();
                details.setModel((HighDFactory<?, ?, ?, ?, Integer, String, Object>)this);
                return details;
            }

            public Clustering<JComponent, Color, Integer, String> createClustering() {
                SwingClustering<Integer, String> clustering = new SwingClustering<Integer, String>();
                clustering.setModel((HighDFactory)this, this.getSubsetDataFrame().getBinningDimension((Object)"Clusters", null));
                return clustering;
            }

            public Regression<JComponent, Color, Integer, String> createRegression() {
                SwingRegression<Integer, String> regression = new SwingRegression<Integer, String>();
                regression.setModel((HighDFactory)this);
                return regression;
            }
        }, SwingDockingFactory.getInstance(), SwingTableFactory.getInstance(), properties);
        this.application = application;
        this.window = window;
        this.expertMode = expertMode;
    }

    public void init() {
        super.init();
        this.resourcesModel = this.application.createResourcesModel();
        this.renderingHintsModel = new SimpleRenderingHintsModel();
        this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void setDocument(JavaHighDDocument document) {
        super.setDocument((HighDDocument)document);
        if (document != null) {
            SwingHighDFactory swingFactory = (SwingHighDFactory)this.hdFactory;
            this.getNorthDockingPanel().attach(this.getNorthDockingPanel().createNakedDockable((Object)((JComponent)this.createTreeMapPanel(this.createTreeMap(swingFactory)).getNativeComponent()), "TreeMap", "com/macrofocus/application/high_d/icons/treemap16x16.png"), AttachAnchor.TOP);
            SwingGeoReferencingServiceFactory geoReferencingServiceFactory = SwingGeoReferencingServiceFactory.getInstance((DataFrame)swingFactory.getDataFrame());
            this.cartoPlot = this.createCartoPlot((SwingHighDFactory<?, ?, ?>)swingFactory, (GeoReferencingServiceFactory<JComponent, ?>)geoReferencingServiceFactory);
            this.customizeCartoPlot((CartoPlot)this.cartoPlot);
            if (this.configurationPanel != null) {
                this.configurationPanel.setModel(this.hdFactory, this.cartoPlot.getModel());
            }
            this.cartoPlotDockable = this.getNorthDockingPanel().createNakedDockable((Object)((JComponent)this.createCartoPlotPanel(this.cartoPlot).getNativeComponent()), "CartoPlot", "com/macrofocus/application/high_d/icons/cartoplot16x16.png");
            this.getNorthDockingPanel().attach(this.cartoPlotDockable, AttachAnchor.TOP);
            if (this.cartoPlot.getModel().getGeoReferencingService().isValid()) {
                this.cartoPlotDockable.getDockingBar().setActive(this.cartoPlotDockable, true);
            }
        }
        this.application.runAsyncUIThread(new Command(){

            public void execute() {
                RegisterAction registerAction = new RegisterAction(HighD.applicationModel);
                registerAction.loadLicenseData(SwingHighDView.this.resourcesModel.getPropertiesModel());
                registerAction.setResourcesModel(SwingHighDView.this.resourcesModel);
                LicenseHelper.checkLicenseData((ApplicationModel)HighD.applicationModel, (RegisterAction)registerAction, (JFrame)SwingHighDView.this.window);
            }
        });
    }

    public MDSPanel createMDSPanel(MDS<JComponent, Color, Font, Integer, String> mds) {
        return new SwingMDSPanel((SwingMDS)mds);
    }

    protected SwingCartoPlot createCartoPlot(SwingHighDFactory<?, ?, ?> swingFactory, GeoReferencingServiceFactory<JComponent, ?> geoReferencingServiceFactory) {
        return new SwingCartoPlot((CartoPlotModel)new DefaultCartoPlotModel(swingFactory.getDataFrame(), swingFactory.getVisual(), geoReferencingServiceFactory.getDefault()));
    }

    private CPComponent<JComponent> createCartoPlotPanel(SwingCartoPlot cartoPlot) {
        return new SwingCartoPlotPanel(cartoPlot);
    }

    protected TreeMap<JComponent, AbstractTreeMapNode, ?, ?, Color, Font> createTreeMap(SwingHighDFactory<?, ?, ?> swingFactory) {
        return swingFactory.createTreeMap();
    }

    private CPComponent<JComponent> createTreeMapPanel(TreeMap<JComponent, AbstractTreeMapNode, ?, ?, Color, Font> treeMap) {
        return new SwingTreeMapPanel(treeMap);
    }

    @Override
    public JavaHighDApplication<JFrame, JComponent, ?, JavaHighDDocument> getApplication() {
        return this.application;
    }

    public void customizeFileSave(CPMenu<JComponent> fileMenu) {
        CPWindow window = this.getApplication().getApplicationState().getWindow((View)this);
        fileMenu.addSeparator();
        FileProvider fileProvider = () -> {
            File file = (File)this.application.getFileManager().getFile((Object)((JFrame)window.getNativeWindow()));
            if (file != null) {
                return file;
            }
            return this.getDocument() != null ? new File(((JavaHighDDocument)this.getDocument()).getDocumentState().getName()) : new File("Untitled");
        };
        ExportGraphicsAction exportGraphicsAction = new ExportGraphicsAction(((JFrame)window.getNativeWindow()).getRootPane(), null, null, this.expertMode);
        if (this.getDocument() != null) {
            ContentProvider contentProvider = () -> (Component)this.getNativeComponent();
            exportGraphicsAction.setContent((ContentProvider<Component>)contentProvider, (FileProvider<File>)fileProvider);
        }
        ActionUICommand exportGraphicsCommand = new ActionUICommand(exportGraphicsAction);
        fileMenu.addAction((UICommand)exportGraphicsCommand);
        ExportDataAction exportDataAction = new ExportDataAction(((JFrame)window.getNativeWindow()).getRootPane(), null, false);
        if (this.getDocument() != null) {
            ContentProvider contentProvider = () -> this.getDocument();
            exportDataAction.setContent((ContentProvider<HighDDocument>)contentProvider, (FileProvider<File>)fileProvider);
        }
        ActionUICommand exportDataCommand = new ActionUICommand(exportDataAction);
        fileMenu.addAction((UICommand)exportDataCommand);
        fileMenu.addSeparator();
        SettingsFileChooserFactory fileChooserFactory = new SettingsFileChooserFactory(this.getDocument(), this.expertMode);
        ImportSettingsUICommand importSettingsUICommand = new ImportSettingsUICommand(fileChooserFactory, (JFrame)window.getNativeWindow(), this.application.getFileManager(), this.resourcesModel);
        ExportSettingsUICommand exportSettingsUICommand = new ExportSettingsUICommand(fileChooserFactory, (JFrame)window.getNativeWindow(), this.application.getFileManager(), this.resourcesModel);
        importSettingsUICommand.setDocument(this.getDocument());
        exportSettingsUICommand.setDocument(this.getDocument());
        fileMenu.addEllipsisAction(importSettingsUICommand);
        fileMenu.addEllipsisAction(exportSettingsUICommand);
        fileMenu.addSeparator();
        SimpleProperty pageFormat = new SimpleProperty(null);
        fileMenu.addAction((UICommand)new ActionUICommand((Action)new PageSetupAction((MutableProperty)pageFormat)));
        PrintComponentAction printAction = new PrintComponentAction((MutableProperty)pageFormat);
        if (this.getDocument() != null) {
            ContentProvider contentProvider = () -> (Component)this.getNativeComponent();
            printAction.setComponent(contentProvider);
        }
        fileMenu.addAction((UICommand)new ActionUICommand((Action)printAction));
    }

    public void createCreateMenu(CPMenuBar<JComponent> menuBar) {
        CPMenu create = menuBar.addMenu("Create");
        this.customizeCreateMenu((CPMenu<JComponent>)create);
    }

    protected void customizeCreateMenu(CPMenu<JComponent> menu) {
        menu.addAction("Scatter Plot", null, new Command(){

            public void execute() {
                SwingScatterPlot scatterPlot = (SwingScatterPlot)SwingHighDView.this.hdFactory.createScatterPlot();
                SwingScatterPlotPanel scatterPlotPanel = new SwingScatterPlotPanel((ScatterPlot)scatterPlot);
                Dockable frame = SwingHighDView.this.getDockingPanel().createNakedDockable((Object)scatterPlotPanel, "Scatter Plot", "com/macrofocus/application/high_d/icons/scatterplot16x16.png");
                ((JComponent)frame.getComponent()).setSize(((JComponent)SwingHighDView.this.scatterPlotDockable.getComponent()).getSize());
                SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().attach(frame);
                Dockable activeDockable = null;
                for (Dockable dockable : SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().getDockables()) {
                    if (!SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().isActive(dockable)) continue;
                    activeDockable = dockable;
                    break;
                }
                SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().setActive(frame, true);
            }
        });
        menu.addAction("Control Chart", null, new Command(){

            public void execute() {
                ControlChart scatterPlot = SwingHighDView.this.hdFactory.createControlChart();
                SwingScatterPlotPanel scatterPlotPanel = new SwingScatterPlotPanel((ScatterPlot)scatterPlot);
                scatterPlotPanel.setYPanelVisible(false);
                Dockable frame = SwingHighDView.this.getDockingPanel().createNakedDockable((Object)scatterPlotPanel, "Control Chart", "com/macrofocus/application/high_d/icons/t216x16.png");
                SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().attach(frame);
                Dockable activeDockable = null;
                for (Dockable dockable : SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().getDockables()) {
                    if (!SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().isActive(dockable)) continue;
                    activeDockable = dockable;
                    break;
                }
                SwingHighDView.this.getNorthDockingPanel().getNorthDockingBar().setActive(frame, true);
            }
        });
    }

    protected void customizeHelpMenu(CPMenu<JComponent> helpMenu) {
        super.customizeHelpMenu(helpMenu);
        PropertiesModel propertiesModel = this.resourcesModel.getPropertiesModel();
        helpMenu.addAction((UICommand)new ActionUICommand((Action)new WebHelpAction("https://www.high-d.com/documentation/", "action.help.label", propertiesModel)));
        helpMenu.addSeparator();
        try {
            helpMenu.addAction((UICommand)new ActionUICommand((Action)this.application.createCheckForUpdateAction(this.window, false)));
            helpMenu.addSeparator();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        RegisterAction registerAction = new RegisterAction(HighD.applicationModel);
        registerAction.setResourcesModel(this.resourcesModel);
        registerAction.setMainFrame(this.window);
        helpMenu.addAction((UICommand)new ActionUICommand((Action)registerAction));
        helpMenu.addSeparator();
        this.aboutAction = new AboutAction(this.resourcesModel, "about.jpg", HighD.applicationModel, this.window.getRootPane());
        helpMenu.addAction((UICommand)new ActionUICommand((Action)this.aboutAction));
    }

    protected void addColorThemeMenuItem(CPMenu<JComponent> menu) {
        CPMenu lookFeelMenu = menu.addMenu("Look & Feel");
        Supplier<Iterable> windowSupplier = () -> Arrays.asList(Window.getWindows());
        ToggleGroup group = new ToggleGroup();
        for (LookAndFeelAction lookAndFeelAction : LookAndFeelAction.HIGH_D_LOOK_AND_FEEL_ACTIONS) {
            if (!lookAndFeelAction.exist()) continue;
            lookAndFeelAction.setRootComponents(windowSupplier);
            lookFeelMenu.addRadio((ToggleUICommand)new ToggleActionToggleUICommand((ToggleAction)lookAndFeelAction), group);
        }
    }

    public AxesPanel<JComponent> createAxes() {
        this.axesPanel = new SwingAxesPanel();
        this.axesPanel.setModel(this.hdFactory);
        return this.axesPanel;
    }

    public ScatterPlotPanel<JComponent> createScatterPlotPanel(ScatterPlot<JComponent, Color, Font, Integer, String> scatterPlot) {
        SwingScatterPlotPanel axisPlotPanel = new SwingScatterPlotPanel(scatterPlot);
        return axisPlotPanel;
    }

    public HighDConfigurationPanel<JComponent> createConfiguration() {
        this.configurationPanel = new SwingHighDConfigurationPanel(null);
        return this.configurationPanel;
    }

    public void showAbout() {
        this.aboutAction.actionPerformed(new ActionEvent((Object)this, 0, null));
    }

    protected void customizeWindowMenu(CPMenu<JComponent> window) {
        super.customizeWindowMenu(window);
        window.addCheckBox((ToggleUICommand)new FullScreenCommand(this.window));
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public Component getCurrentView() {
        return null;
    }

    public SwingHighDConfigurationPanel<Integer, String> getConfiguration() {
        if (this.configurationPanel == null) {
            this.createConfiguration();
        }
        return this.configurationPanel;
    }

    public SwingAxesPanel<Integer, String> getAxes() {
        if (this.axesPanel == null) {
            this.createAxes();
        }
        return this.axesPanel;
    }

    public HighDModel<Object, Object> getModel() {
        return null;
    }

    public DockingPanel<JComponent> getDockingManager() {
        return this.getDockingPanel();
    }

    public Dockable<JComponent> getCartoPlotDockable() {
        return this.cartoPlotDockable;
    }
}

