/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.settings;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.common.scale.NumericTransform;
import com.macrofocus.common.scale.Transform;
import com.macrofocus.filter.Filter;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.order.MutableVisibleOrder;
import de.javasoft.syntheticaaddons.DropDownButton;
import de.javasoft.widgets.JYCheckBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractSpinnerModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class SwingAxisPropertyPanel<R, C> {
    private TableModel model;
    private ListSelectionModel selectionModel;
    private MutableVisibleOrder<AxisModel<R, C>> axisOrder;
    private MutableVisibleOrder<AxisModel<R, C>> filtersAxisOrder;
    private Filter<R> filter;
    private JCheckBox categoriesCheckBox;
    private JCheckBox tableCheckBox;
    private JCheckBox visualizationsCheckBox;
    private JSpinner minimumTextField;
    private JSpinner maximumTextField;
    private JPanel mainPanel;
    private JButton zoomOutButton;
    private DropDownButton zoomInButton;
    private JSpinner startTextField;
    private JSpinner endTextField;
    private JSpinner numberOfBins;
    private JComboBox binningTypeComboBox;
    private JComboBox scaleTransformComboBox;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public SwingAxisPropertyPanel() {
        this.$$$setupUI$$$();
        this.categoriesCheckBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean s = SwingAxisPropertyPanel.this.categoriesCheckBox.isSelected();
                Object[] array = SwingAxisPropertyPanel.this.getSelectedFilterAxisModels();
                if (s) {
                    SwingAxisPropertyPanel.this.filtersAxisOrder.show(array);
                } else {
                    SwingAxisPropertyPanel.this.filtersAxisOrder.hide(array);
                }
            }
        }, (Object)this.categoriesCheckBox));
        this.visualizationsCheckBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean s = SwingAxisPropertyPanel.this.visualizationsCheckBox.isSelected();
                Object[] array = SwingAxisPropertyPanel.this.getSelectedAxisModels();
                if (s) {
                    SwingAxisPropertyPanel.this.axisOrder.show(array);
                } else {
                    SwingAxisPropertyPanel.this.axisOrder.hide(array);
                }
            }
        }, (Object)this.visualizationsCheckBox));
        this.tableCheckBox.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean s = SwingAxisPropertyPanel.this.tableCheckBox.isSelected();
                for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                    SwingAxisPropertyPanel.this.model.setValueAt(s, r, 2);
                }
            }
        }, (Object)this.tableCheckBox));
        this.minimumTextField.setModel(new NumberSpinnerModel());
        this.minimumTextField.setEditor(new NumberEditor(this.minimumTextField));
        this.minimumTextField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object value = SwingAxisPropertyPanel.this.minimumTextField.getValue();
                if (value != null) {
                    for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                        SwingAxisPropertyPanel.this.model.setValueAt(value, r, 4);
                    }
                }
            }
        });
        this.maximumTextField.setModel(new NumberSpinnerModel());
        this.maximumTextField.setEditor(new NumberEditor(this.maximumTextField));
        this.maximumTextField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object value = SwingAxisPropertyPanel.this.maximumTextField.getValue();
                if (value != null) {
                    for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                        SwingAxisPropertyPanel.this.model.setValueAt(value, r, 5);
                    }
                }
            }
        });
        Vector numericTransformStream = Arrays.stream(NumericTransform.values()).filter(x -> x.getInverse() != null && x != NumericTransform.RECIPROCAL && x != NumericTransform.REVERSE).collect(Collectors.toCollection(Vector::new));
        this.scaleTransformComboBox.setModel(new DefaultComboBoxModel(numericTransformStream));
        this.scaleTransformComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object value = e.getItem();
                if (value != null) {
                    for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                        SwingAxisPropertyPanel.this.model.setValueAt(value, r, 10);
                    }
                }
            }
        });
        this.startTextField.setModel(new NumberSpinnerModel());
        this.startTextField.setEditor(new NumberEditor(this.startTextField));
        this.startTextField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object value = SwingAxisPropertyPanel.this.startTextField.getValue();
                if (value != null) {
                    for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                        SwingAxisPropertyPanel.this.model.setValueAt(value, r, 6);
                    }
                }
            }
        });
        this.endTextField.setModel(new NumberSpinnerModel());
        this.endTextField.setEditor(new NumberEditor(this.endTextField));
        this.endTextField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object value = SwingAxisPropertyPanel.this.endTextField.getValue();
                if (value != null) {
                    for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                        SwingAxisPropertyPanel.this.model.setValueAt(value, r, 7);
                    }
                }
            }
        });
        this.binningTypeComboBox.setModel(new DefaultComboBoxModel<AxisModel.BinType>(new AxisModel.BinType[]{AxisModel.BinType.Fixed, AxisModel.BinType.Sigma}));
        this.binningTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object value = e.getItem();
                if (value != null) {
                    for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                        SwingAxisPropertyPanel.this.model.setValueAt(value, r, 8);
                    }
                }
            }
        });
        this.numberOfBins.setModel(new NumberSpinnerModel());
        this.numberOfBins.setEditor(new NumberEditor(this.numberOfBins));
        this.numberOfBins.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object value = SwingAxisPropertyPanel.this.numberOfBins.getValue();
                if (value != null) {
                    for (int r : SwingAxisPropertyPanel.this.getSelected()) {
                        SwingAxisPropertyPanel.this.model.setValueAt(value, r, 9);
                    }
                }
            }
        });
        this.refresh();
    }

    private AxisModel[] getSelectedAxisModels() {
        List<Integer> selected = this.getSelected();
        AxisModel[] array = new AxisModel[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            int index = selected.get(i);
            array[i] = (AxisModel)this.axisOrder.getAll(index);
        }
        return array;
    }

    private AxisModel[] getSelectedFilterAxisModels() {
        List<Integer> selected = this.getSelected();
        AxisModel[] array = new AxisModel[selected.size()];
        for (int i = 0; i < selected.size(); ++i) {
            int index = selected.get(i);
            array[i] = (AxisModel)this.axisOrder.getAll(index);
        }
        return array;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setModel(MutableVisibleOrder<AxisModel<R, C>> axisOrder, MutableVisibleOrder<AxisModel<R, C>> filtersAxisOrder, Filter<R> filter, TableModel model, ListSelectionModel selectionModel) {
        this.model = model;
        this.selectionModel = selectionModel;
        this.filter = filter;
        this.axisOrder = axisOrder;
        this.filtersAxisOrder = filtersAxisOrder;
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SwingAxisPropertyPanel.this.refresh();
                }
            }
        });
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingAxisPropertyPanel.this.refresh();
            }
        });
    }

    private void refresh() {
        List<Integer> selected = this.getSelected();
        boolean isSelected = selected.size() > 0;
        this.setEnabled((JYCheckBox)this.categoriesCheckBox, isSelected);
        this.setEnabled((JYCheckBox)this.visualizationsCheckBox, isSelected);
        this.setEnabled((JYCheckBox)this.tableCheckBox, isSelected);
        switch (selected.size()) {
            case 0: {
                this.setState((JYCheckBox)this.categoriesCheckBox, JYCheckBox.State.DESELECTED);
                this.setState((JYCheckBox)this.visualizationsCheckBox, JYCheckBox.State.DESELECTED);
                this.setState((JYCheckBox)this.tableCheckBox, JYCheckBox.State.DESELECTED);
                this.minimumTextField.setValue(null);
                this.maximumTextField.setValue(null);
                this.minimumTextField.setEnabled(false);
                this.maximumTextField.setEnabled(false);
                this.scaleTransformComboBox.setEnabled(false);
                this.startTextField.setValue(null);
                this.endTextField.setValue(null);
                this.numberOfBins.setValue(null);
                this.startTextField.setEnabled(false);
                this.endTextField.setEnabled(false);
                this.binningTypeComboBox.setEnabled(false);
                this.numberOfBins.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                break;
            }
            case 1: {
                int r = selected.get(0);
                this.setState((JYCheckBox)this.categoriesCheckBox, (Boolean)this.model.getValueAt(r, 0) != false ? JYCheckBox.State.SELECTED : JYCheckBox.State.DESELECTED);
                this.setState((JYCheckBox)this.visualizationsCheckBox, (Boolean)this.model.getValueAt(r, 1) != false ? JYCheckBox.State.SELECTED : JYCheckBox.State.DESELECTED);
                this.setState((JYCheckBox)this.tableCheckBox, (Boolean)this.model.getValueAt(r, 2) != false ? JYCheckBox.State.SELECTED : JYCheckBox.State.DESELECTED);
                this.minimumTextField.setValue(this.model.getValueAt(r, 4));
                this.maximumTextField.setValue(this.model.getValueAt(r, 5));
                this.minimumTextField.setEnabled(this.model.getValueAt(r, 4) != null);
                this.maximumTextField.setEnabled(this.model.getValueAt(r, 5) != null);
                this.scaleTransformComboBox.setEnabled(this.model.getValueAt(r, 10) != null);
                this.scaleTransformComboBox.setSelectedItem(this.model.getValueAt(r, 10));
                this.startTextField.setEnabled(this.model.getValueAt(r, 6) != null);
                this.startTextField.setValue(this.model.getValueAt(r, 6));
                this.endTextField.setEnabled(this.model.getValueAt(r, 7) != null);
                this.endTextField.setValue(this.model.getValueAt(r, 7));
                this.binningTypeComboBox.setEnabled(this.model.getValueAt(r, 8) != null);
                this.binningTypeComboBox.setSelectedItem(this.model.getValueAt(r, 8));
                this.numberOfBins.setEnabled(this.model.getValueAt(r, 9) != null);
                this.numberOfBins.setValue(this.model.getValueAt(r, 9));
                ((NumberSpinnerModel)this.minimumTextField.getModel()).setMinimum((Comparable)this.model.getValueAt(r, 4));
                ((NumberSpinnerModel)this.minimumTextField.getModel()).setMaximum((Comparable)this.model.getValueAt(r, 5));
                ((NumberSpinnerModel)this.maximumTextField.getModel()).setMinimum((Comparable)this.model.getValueAt(r, 4));
                ((NumberSpinnerModel)this.maximumTextField.getModel()).setMaximum((Comparable)this.model.getValueAt(r, 5));
                ((NumberSpinnerModel)this.startTextField.getModel()).setMinimum((Comparable)this.model.getValueAt(r, 4));
                ((NumberSpinnerModel)this.startTextField.getModel()).setMaximum((Comparable)this.model.getValueAt(r, 5));
                ((NumberSpinnerModel)this.endTextField.getModel()).setMinimum((Comparable)this.model.getValueAt(r, 4));
                ((NumberSpinnerModel)this.endTextField.getModel()).setMaximum((Comparable)this.model.getValueAt(r, 5));
                ((NumberSpinnerModel)this.numberOfBins.getModel()).setMinimum(Integer.valueOf(1));
                ((NumberSpinnerModel)this.numberOfBins.getModel()).setMaximum(Integer.valueOf(1000));
                this.zoomOutButton.setEnabled(this.model.getValueAt(r, 4) != null && this.model.getValueAt(r, 5) != null);
                this.zoomInButton.setEnabled(this.model.getValueAt(r, 4) != null && this.model.getValueAt(r, 5) != null);
                break;
            }
            default: {
                this.setState((JYCheckBox)this.categoriesCheckBox, this.getCommonState(selected, 0));
                this.setState((JYCheckBox)this.visualizationsCheckBox, this.getCommonState(selected, 1));
                this.setState((JYCheckBox)this.tableCheckBox, this.getCommonState(selected, 2));
                this.minimumTextField.setValue(this.getCommonValue(selected, 4));
                this.maximumTextField.setValue(this.getCommonValue(selected, 5));
                this.minimumTextField.setEnabled(this.getCommonClass(selected, 4) == Double.class);
                this.maximumTextField.setEnabled(this.getCommonClass(selected, 5) == Double.class);
                this.scaleTransformComboBox.setEnabled(this.getCommonClass(selected, 10) == Transform.class);
                this.binningTypeComboBox.setEnabled(this.getCommonClass(selected, 8) == AxisModel.BinType.class);
                this.numberOfBins.setEnabled(this.getCommonClass(selected, 9) == Integer.class);
                ((NumberSpinnerModel)this.minimumTextField.getModel()).setMinimum((Comparable)this.getCommonValue(selected, 4));
                ((NumberSpinnerModel)this.minimumTextField.getModel()).setMaximum((Comparable)this.getCommonValue(selected, 5));
                ((NumberSpinnerModel)this.maximumTextField.getModel()).setMinimum((Comparable)this.getCommonValue(selected, 4));
                ((NumberSpinnerModel)this.maximumTextField.getModel()).setMaximum((Comparable)this.getCommonValue(selected, 5));
                this.scaleTransformComboBox.getModel().setSelectedItem(this.getCommonValue(selected, 10));
                ((NumberSpinnerModel)this.startTextField.getModel()).setMinimum((Comparable)this.getCommonValue(selected, 4));
                ((NumberSpinnerModel)this.startTextField.getModel()).setMaximum((Comparable)this.getCommonValue(selected, 5));
                ((NumberSpinnerModel)this.endTextField.getModel()).setMinimum((Comparable)this.getCommonValue(selected, 4));
                ((NumberSpinnerModel)this.endTextField.getModel()).setMaximum((Comparable)this.getCommonValue(selected, 5));
                this.binningTypeComboBox.getModel().setSelectedItem(this.getCommonValue(selected, 8));
                this.numberOfBins.getModel().setValue(this.getCommonValue(selected, 9));
                this.startTextField.setValue(null);
                this.endTextField.setValue(null);
                this.startTextField.setEnabled(false);
                this.endTextField.setEnabled(false);
                this.zoomOutButton.setEnabled(this.getCommonClass(selected, 4) == Double.class && this.getCommonClass(selected, 5) == Double.class);
                this.zoomInButton.setEnabled(this.getCommonClass(selected, 4) == Double.class && this.getCommonClass(selected, 5) == Double.class);
            }
        }
    }

    private JYCheckBox.State getCommonState(List<Integer> rows, int column) {
        JYCheckBox.State value = JYCheckBox.State.DESELECTED;
        if (rows.size() > 0) {
            value = (Boolean)this.model.getValueAt(rows.get(0), column) != false ? JYCheckBox.State.SELECTED : JYCheckBox.State.DESELECTED;
            for (int i = 1; i < rows.size(); ++i) {
                JYCheckBox.State v;
                int r = rows.get(i);
                JYCheckBox.State state = v = (Boolean)this.model.getValueAt(r, column) != false ? JYCheckBox.State.SELECTED : JYCheckBox.State.DESELECTED;
                if (v == value) continue;
                value = JYCheckBox.State.HALF_SELECTED;
                break;
            }
        }
        return value;
    }

    private Object getCommonValue(List<Integer> rows, int column) {
        Object value = null;
        if (rows.size() > 0) {
            value = this.model.getValueAt(rows.get(0), column);
            for (int i = 1; i < rows.size(); ++i) {
                int r = rows.get(i);
                Object v = this.model.getValueAt(r, column);
                if (v != null && v.equals(value)) continue;
                value = null;
                break;
            }
        }
        return value;
    }

    private Object getCommonClass(List<Integer> rows, int column) {
        Class<?> cl = null;
        if (rows.size() > 0) {
            cl = this.model.getValueAt(rows.get(0), column) != null ? this.model.getValueAt(rows.get(0), column).getClass() : null;
            for (int i = 1; i < rows.size(); ++i) {
                int r = rows.get(i);
                Object v = this.model.getValueAt(r, column);
                if (v != null && v.getClass().equals(cl)) continue;
                cl = null;
                break;
            }
        }
        return cl;
    }

    private void setEnabled(JYCheckBox checkBox, boolean enabled) {
        if (checkBox.isEnabled() != enabled) {
            checkBox.setEnabled(enabled);
        }
    }

    private void setState(JYCheckBox checkBox, JYCheckBox.State state) {
        if (checkBox.getState() != state) {
            checkBox.setState(state);
        }
    }

    private List<Integer> getSelected() {
        if (this.model != null) {
            ArrayList<Integer> selected = new ArrayList<Integer>();
            for (int r = 0; r < this.model.getRowCount(); ++r) {
                if (!this.selectionModel.isSelectedIndex(r)) continue;
                selected.add(r);
            }
            return selected;
        }
        return Collections.EMPTY_LIST;
    }

    private void createUIComponents() {
        ResetAction resetAction = new ResetAction();
        this.zoomOutButton = new JButton(resetAction);
        VisibleRangeResetAction zoomInAction = new VisibleRangeResetAction();
        this.zoomInButton = new DropDownButton((Action)zoomInAction);
        String label = (String)zoomInAction.getValue("Name");
        this.zoomInButton.setText("");
        this.zoomInButton.setText(label);
        this.zoomInButton.getPopupMenu().add(zoomInAction);
        this.zoomInButton.getPopupMenu().add(new FilteredRangeResetAction());
        this.zoomInButton.getPopupMenu().add(new JSeparator());
        this.zoomInButton.getPopupMenu().add(new SharedRangeResetAction());
        this.zoomInButton.getPopupMenu().add(new MeanRangeResetAction());
        this.zoomInButton.getPopupMenu().add(new SymetricalResetAction());
        this.zoomInButton.getPopupMenu().add(new RoundedResetAction());
        this.categoriesCheckBox = new JYCheckBox();
        ((JYCheckBox)this.categoriesCheckBox).setStateInteractive(false);
        this.tableCheckBox = new JYCheckBox();
        ((JYCheckBox)this.tableCheckBox).setStateInteractive(false);
        this.visualizationsCheckBox = new JYCheckBox();
        ((JYCheckBox)this.visualizationsCheckBox).setStateInteractive(false);
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        panel2.setBorder(BorderFactory.createTitledBorder(null, "Visibility", 0, 0, null, null));
        this.categoriesCheckBox.setText("Categories");
        panel2.add((Component)this.categoriesCheckBox, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.tableCheckBox.setText("Table");
        this.tableCheckBox.setVisible(false);
        panel2.add((Component)this.tableCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.visualizationsCheckBox.setText("Visualizations");
        panel2.add((Component)this.visualizationsCheckBox, new GridConstraints(1, 0, 1, 1, 0, 1, 5, 0, new Dimension(0, -1), new Dimension(0, -1), new Dimension(100000, -1), 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        panel3.setBorder(BorderFactory.createTitledBorder(null, "Scale", 0, 0, null, null));
        JLabel label1 = new JLabel();
        label1.setText("Minimum: ");
        panel3.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.minimumTextField = new JSpinner();
        panel3.add((Component)this.minimumTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(150, -1), null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Maximum: ");
        panel3.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.maximumTextField = new JSpinner();
        panel3.add((Component)this.maximumTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(150, -1), null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel4, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.zoomOutButton.setEnabled(true);
        panel4.add((Component)this.zoomOutButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel4.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 1, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel5, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.zoomInButton.setEnabled(true);
        panel5.add((Component)this.zoomInButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(0, -1), null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel5.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 5, 1, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        label3.setText("Scale: ");
        panel3.add((Component)label3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.scaleTransformComboBox = new JComboBox();
        panel3.add((Component)this.scaleTransformComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel1.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        panel6.setBorder(BorderFactory.createTitledBorder(null, "Filter", 0, 0, null, null));
        JLabel label4 = new JLabel();
        label4.setText("Start: ");
        panel6.add((Component)label4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.startTextField = new JSpinner();
        panel6.add((Component)this.startTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(150, -1), null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("End: ");
        panel6.add((Component)label5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.endTextField = new JSpinner();
        panel6.add((Component)this.endTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(150, -1), null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        panel7.setBorder(BorderFactory.createTitledBorder(null, "Distribution", 0, 0, null, null));
        JLabel label6 = new JLabel();
        label6.setText("Number of bins:");
        panel7.add((Component)label6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.numberOfBins = new JSpinner();
        panel7.add((Component)this.numberOfBins, new GridConstraints(1, 1, 1, 1, 8, 1, 5, 0, new Dimension(0, -1), new Dimension(150, -1), null, 0, false));
        JLabel label7 = new JLabel();
        label7.setText("Type of binning:");
        panel7.add((Component)label7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.binningTypeComboBox = new JComboBox();
        panel7.add((Component)this.binningTypeComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    public TableHelper.ColumnStatistics getColumnStatistics(AxisModel<R, C> axisModel) {
        Number min = null;
        Number max = null;
        double sum = 0.0;
        long count = 0L;
        for (int row = 0; row < axisModel.getRowCount(); ++row) {
            Number value;
            Object r = axisModel.getRow(row);
            if (this.filter.isFiltered(r) || axisModel.getValue(r) == null || (value = axisModel.getValue(r)) == null) continue;
            if (value instanceof Number) {
                Number number = value;
                double d = number.doubleValue();
                if (number instanceof Double) {
                    if (Double.isNaN(d) || Double.isInfinite(d)) continue;
                    if (min == null || d < ((Number)min).doubleValue()) {
                        min = number;
                    }
                    if (max == null || d > ((Number)max).doubleValue()) {
                        max = number;
                    }
                    sum += number.doubleValue();
                    ++count;
                    continue;
                }
                if (number instanceof Float) {
                    float f = number.floatValue();
                    if (Float.isNaN(f) || Float.isInfinite(f)) continue;
                    if (min == null || d < ((Number)min).doubleValue()) {
                        min = number;
                    }
                    if (max != null && !(d > ((Number)max).doubleValue())) continue;
                    max = number;
                    continue;
                }
                if (min == null || d < ((Number)min).doubleValue()) {
                    min = number;
                }
                if (max == null || d > ((Number)max).doubleValue()) {
                    max = number;
                }
                sum += d;
                ++count;
                continue;
            }
            if (!(value instanceof Date)) continue;
            Date date = (Date)((Object)value);
            long time = date.getTime();
            if (min == null || (double)time < ((Number)min).doubleValue()) {
                min = time;
            }
            if (max == null || (double)time > ((Number)max).doubleValue()) {
                max = time;
            }
            sum += (double)time;
            ++count;
        }
        return new TableHelper.ColumnStatistics(min, max, sum, count);
    }

    private static class NumberSpinnerModel
    extends AbstractSpinnerModel {
        private static final double STEP_RATIO = 0.01;
        Object value;
        private Comparable minimum;
        private Comparable maximum;

        private NumberSpinnerModel() {
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            if (value == null && this.value != null || value != null && !value.equals(this.value)) {
                this.value = value;
                this.fireStateChanged();
            }
        }

        @Override
        public Object getNextValue() {
            if (this.value instanceof Number) {
                return ((Number)this.value).doubleValue() + this.computeStepSize();
            }
            return this.value;
        }

        @Override
        public Object getPreviousValue() {
            if (this.value instanceof Number) {
                return ((Number)this.value).doubleValue() - this.computeStepSize();
            }
            return this.value;
        }

        public Comparable getMinimum() {
            return this.minimum;
        }

        public Comparable getMaximum() {
            return this.maximum;
        }

        public void setMinimum(Comparable minimum) {
            this.minimum = minimum;
        }

        public void setMaximum(Comparable maximum) {
            this.maximum = maximum;
        }

        protected double computeStepSize() {
            if (this.getMaximum() instanceof Number) {
                double max = ((Number)((Object)this.getMaximum())).doubleValue();
                double min = ((Number)((Object)this.getMinimum())).doubleValue();
                long magnitude = Math.round(Math.log10(max - min));
                double stepSize = 0.01 * Math.pow(10.0, magnitude);
                return stepSize;
            }
            return 0.0;
        }
    }

    public static class NumberEditor
    extends JSpinner.DefaultEditor {
        private static String getDefaultPattern(Locale locale) {
            return "###,###.###";
        }

        public NumberEditor(JSpinner spinner) {
            this(spinner, NumberEditor.getDefaultPattern(spinner.getLocale()));
        }

        public NumberEditor(JSpinner spinner, String decimalFormatPattern) {
            this(spinner, new DecimalFormat(decimalFormatPattern));
        }

        private NumberEditor(JSpinner spinner, DecimalFormat format) {
            super(spinner);
            if (!(spinner.getModel() instanceof NumberSpinnerModel)) {
                throw new IllegalArgumentException("model not a SpinnerNumberModel");
            }
            NumberSpinnerModel model = (NumberSpinnerModel)spinner.getModel();
            NumberEditorFormatter formatter = new NumberEditorFormatter(model, format);
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
            JFormattedTextField ftf = this.getTextField();
            ftf.setEditable(true);
            ftf.setFormatterFactory(factory);
            ftf.setHorizontalAlignment(4);
            try {
                String maxString = formatter.valueToString(model.getMinimum());
                String minString = formatter.valueToString(model.getMaximum());
                ftf.setColumns(Math.max(maxString.length(), minString.length()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public DecimalFormat getFormat() {
            return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            super("Reset to Data Range");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                DataFrameHelper.ColumnStatistics columnStatistics = axisModel.getColumnStatistics();
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                if (min == null || max == null) continue;
                axisModel.setMinMax(min.doubleValue(), max.doubleValue());
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private class VisibleRangeResetAction
    extends AbstractAction {
        public VisibleRangeResetAction() {
            super("Set to Visible Range");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                TableHelper.ColumnStatistics columnStatistics = SwingAxisPropertyPanel.this.getColumnStatistics(axisModel);
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                if (min == null || max == null) continue;
                axisModel.setMinMax(min.doubleValue(), max.doubleValue());
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private class FilteredRangeResetAction
    extends AbstractAction {
        public FilteredRangeResetAction() {
            super("Set to Range Slider");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                axisModel.setMinMax(axisModel.getInterval().getStart(), axisModel.getInterval().getEnd());
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private class SharedRangeResetAction
    extends AbstractAction {
        public SharedRangeResetAction() {
            super("Make Common Range");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Number sharedMin = null;
            Number sharedMax = null;
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                Double min = axisModel.getMinimum();
                Double max = axisModel.getMaximum();
                if (min == null || max == null) continue;
                if (sharedMin == null || sharedMin.doubleValue() > min) {
                    sharedMin = min;
                }
                if (sharedMax != null && !(sharedMax.doubleValue() < max)) continue;
                sharedMax = max;
            }
            if (sharedMin != null && sharedMax != null) {
                for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                    axisModel.getInterval().setValue(sharedMin.doubleValue(), sharedMax.doubleValue() - sharedMin.doubleValue());
                    axisModel.setMinMax(sharedMin.doubleValue(), sharedMax.doubleValue());
                }
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private class MeanRangeResetAction
    extends AbstractAction {
        public MeanRangeResetAction() {
            super("Make Symmetrical around Mean");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                TableHelper.ColumnStatistics columnStatistics = SwingAxisPropertyPanel.this.getColumnStatistics(axisModel);
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                Double mean = columnStatistics.getMean();
                if (min == null || max == null || mean == null) continue;
                double maxDeviation = Math.abs(min.doubleValue() - mean) > Math.abs(max.doubleValue() - mean) ? mean - min.doubleValue() : max.doubleValue() - mean;
                axisModel.setMinMax(mean - maxDeviation, mean + maxDeviation);
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private class SymetricalResetAction
    extends AbstractAction {
        public SymetricalResetAction() {
            super("Make Symmetrical Range around 0");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                Double min = axisModel.getMinimum();
                Double max = axisModel.getMaximum();
                if (min == null || max == null) continue;
                if (min < 0.0 && min > 0.0) {
                    double diffMin = 0.0 - min;
                    double diffMax = max;
                    double maxDiff = Math.max(diffMin, diffMax);
                    axisModel.setMinMax(0.0 - maxDiff, maxDiff);
                    continue;
                }
                axisModel.setMinMax(-((Number)max).doubleValue(), ((Number)max).doubleValue());
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private class RoundedResetAction
    extends AbstractAction {
        public RoundedResetAction() {
            super("Round Range Values");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                Double min = axisModel.getMinimum();
                Double max = axisModel.getMaximum();
                if (min == null || max == null) continue;
                double s = Math.signum(min) * Math.pow(10.0, Math.floor(Math.log10(Math.abs(min))));
                double e = Math.signum(max) * Math.pow(10.0, Math.ceil(Math.log10(Math.abs(max))));
                axisModel.setMinMax(s, e);
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private class StandardDeviationAction
    extends AbstractAction {
        private final int sigma;

        public StandardDeviationAction(int sigma) {
            super("Set to -" + sigma + "\u03c3 to " + sigma + "\u03c3");
            this.sigma = sigma;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (AxisModel axisModel : SwingAxisPropertyPanel.this.getSelectedAxisModels()) {
                TableHelper.ColumnStatistics columnStatistics = SwingAxisPropertyPanel.this.getColumnStatistics(axisModel);
                Number min = columnStatistics.getMin();
                Number max = columnStatistics.getMax();
                Double mean = axisModel.getMean();
                Double stdDev = axisModel.getStdDev();
                if (min == null || max == null || mean == null || stdDev == null) continue;
                double minSigma = mean - (double)this.sigma * stdDev;
                double maxSigma = mean + (double)this.sigma * stdDev;
                if (minSigma < min.doubleValue()) {
                    minSigma = min.doubleValue();
                }
                if (maxSigma > max.doubleValue()) {
                    maxSigma = max.doubleValue();
                }
                axisModel.setMinMax(minSigma, maxSigma);
            }
            SwingAxisPropertyPanel.this.refresh();
        }
    }

    private static class NumberEditorFormatter
    extends NumberFormatter {
        private final NumberSpinnerModel model;

        NumberEditorFormatter(NumberSpinnerModel model, NumberFormat format) {
            super(format);
            this.model = model;
            this.setValueClass(Number.class);
        }

        public void setMinimum(Comparable min) {
            this.model.setMinimum(min);
        }

        public Comparable getMinimum() {
            return null;
        }

        public void setMaximum(Comparable max) {
            this.model.setMaximum(max);
        }

        public Comparable getMaximum() {
            return null;
        }
    }
}

