/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.high_d.HighDResource;
import com.macrofocus.application.high_d.document.swing.SwingHighDApplication;
import com.macrofocus.application.logging.DetailsDialogLoggingOutput;
import com.macrofocus.jide.JideHelper;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.resources.ResourceBundleResourcesModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.cli.CLArgsParser;
import com.macrofocus.util.cli.CLOption;
import com.macrofocus.util.cli.CLOptionDescriptor;
import com.macrofocus.util.cli.CLUtil;
import com.macrofocus.util.java2d.RenderingHintsModel;
import com.macrofocus.util.java2d.SimpleRenderingHintsModel;
import com.macrofocus.util.logging.MacrofocusLogFactory;
import com.macrofocus.util.logging.SwingLogging;
import com.macrofocus.util.logging.SwingLoggingOutput;
import com.macrofocus.util.registration.RegisterAction;
import com.macrofocus.util.swing.plaf.action.NamedLookAndFeelAction;
import java.awt.RenderingHints;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import javax.swing.UIManager;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;

public class HighD {
    public static final ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_APP;
    private final ResourcesModel resourcesModel = new ResourceBundleResourcesModel(HighDResource.class, HighDResource.class, Locale.getDefault(), HighDResource.getPreferences());
    private final RenderingHintsModel renderingHintsModel = new SimpleRenderingHintsModel();
    public static boolean expertMode = false;
    private static final int EXPERT_OPT = 101;
    private static final int LF_OPT = 102;
    private static final int UI_SCALING_OPT = 117;
    private static final int HELP_OPT = 104;
    private static final CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("expert", 8, 101, "Run High-D in expert mode"), new CLOptionDescriptor("lf", 2, 102, "Set the look and feel"), new CLOptionDescriptor("uiscaling", 2, 117, "Scale the UI"), new CLOptionDescriptor("help", 8, 104, "Show the help")};

    public HighD(String lf, String filename) {
        File dir;
        String exeDir;
        File dir2;
        String appDir;
        File dir3;
        this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.renderingHintsModel.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ArrayList<File> defaultSettingsDirectories = new ArrayList<File>();
        String userDir = System.getProperty("user.dir");
        if (userDir != null && (dir3 = new File(userDir)).exists()) {
            defaultSettingsDirectories.add(dir3);
        }
        if ((appDir = System.getProperty("install4j.appDir")) != null && (dir2 = new File(appDir)).exists()) {
            defaultSettingsDirectories.add(dir2);
        }
        if ((exeDir = System.getProperty("install4j.exeDir")) != null && (dir = new File(exeDir)).exists()) {
            defaultSettingsDirectories.add(dir);
        }
        RegisterAction registerAction = new RegisterAction(applicationModel);
        LicenseModel licenseModel = registerAction.loadLicenseData(this.resourcesModel.getPropertiesModel());
        Element settings = null;
        for (File directory : defaultSettingsDirectories) {
            File[] files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("High-D.mhds");
                }
            });
            if (files == null || files.length <= 0) continue;
            Builder builder = new Builder(false);
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(files[0]));
                Document highD = builder.build((InputStream)bis);
                settings = highD.getRootElement();
                if (licenseModel.verify() == LicenseModel.State.Valid || !settings.getLocalName().equals("High-D")) break;
                Attribute userAttribute = settings.getAttribute("user");
                Attribute keyAttribute = settings.getAttribute("key");
                if (userAttribute == null || keyAttribute == null) break;
                licenseModel = registerAction.loadLicenseData(userAttribute.getValue(), keyAttribute.getValue());
                break;
            }
            catch (ParsingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (lf == null) {
            lf = (String)this.getResourcesModel().getPropertiesModel().getValue("lookandfeel");
        }
        NamedLookAndFeelAction lfAction = null;
        try {
            if (lf != null && lf.length() != 0) {
                lfAction = new NamedLookAndFeelAction(lf);
                JideHelper.setupLookAndFeel();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        SwingLogging.setCommonsLogFactory(MacrofocusLogFactory.class);
        SwingLogging.getInstance().setOutput(new SwingLoggingOutput[]{new DetailsDialogLoggingOutput(null)});
    }

    public ResourcesModel getResourcesModel() {
        return this.resourcesModel;
    }

    public static void main(String[] args) {
        CLArgsParser parser = new CLArgsParser(args, options);
        if (null != parser.getErrorString()) {
            System.err.println("Error: " + parser.getErrorString());
            return;
        }
        Vector clOptions = parser.getArguments();
        String filename = null;
        Object language = null;
        boolean loggingOut = false;
        boolean loggingErr = false;
        String lf = "synthetica-whitevision";
        Object out = null;
        Double uiScaling = null;
        for (Object clOption : clOptions) {
            CLOption option = (CLOption)clOption;
            switch (option.getId()) {
                case 0: {
                    filename = option.getArgument();
                    break;
                }
                case 101: {
                    expertMode = true;
                    break;
                }
                case 102: {
                    lf = option.getArgument();
                    break;
                }
                case 117: {
                    uiScaling = Double.parseDouble(option.getArgument());
                    Double scaleFactor = uiScaling * 100.0;
                    UIManager.put("Synthetica.scaleFactor", scaleFactor);
                    break;
                }
                case 104: {
                    CLUtil.printUsage((ApplicationModel)applicationModel, (CLOptionDescriptor[])options);
                }
            }
        }
        String fileUrl = filename;
        SwingHighDApplication application = new SwingHighDApplication(lf, expertMode);
        application.init();
        application.runAsyncUIThread(() -> {
            try {
                application.start(fileUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static SwingHighDApplication init(String lf) {
        SwingHighDApplication application = new SwingHighDApplication(lf, expertMode);
        application.init();
        return application;
    }
}

