/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.view.clustering;

import com.macrofocus.application.high_d.view.clustering.ClusterersSettingsPanel;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.clustering.Clustering;
import com.macrofocus.high_d.clustering.HighD_Cluster;
import com.macrofocus.high_d.clustering.High_DPoint;
import com.macrofocus.high_d.filters.CategoricalFilterComponent;
import com.macrofocus.high_d.filters.swing.DefaultSwingCategoricalFilterComponent;
import com.macrofocus.molap.subset.SingleBinningDimension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.math3.ml.clustering.Cluster;

public class SwingClustering<Row, Column>
extends JPanel
implements Clustering<JComponent, Color, Row, Column> {
    final JList<HighD_Cluster<Row>> list = new JList();
    private DefaultListModel<HighD_Cluster<Row>> listModel;
    private HighDFactory<JComponent, Color, Font, ?, Row, Column, Object> factory;
    private SingleBinningDimension<Row, ?> binningDimension;

    public SwingClustering() {
        this.setLayout(new BorderLayout());
        JPanel controls = new JPanel(new BorderLayout());
        final ClusterersSettingsPanel settingsPanel = new ClusterersSettingsPanel();
        controls.add((Component)settingsPanel.getMainPanel(), "North");
        JButton clusterButton = new JButton(new AbstractAction("Create Clusters"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingClustering.this.binningDimension.filterAll();
                ArrayList<High_DPoint> values = new ArrayList<High_DPoint>();
                for (AxisGroupModel group : SwingClustering.this.factory.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
                    for (Object r : SwingClustering.this.factory.getDataFrame().rows()) {
                        if (SwingClustering.this.factory.getVisual().getFilter().isFiltered(r)) continue;
                        double[] v = new double[group.getAxisOrder().size()];
                        int c = 0;
                        boolean missing = false;
                        for (AxisModel axisModel : group.getAxisOrder()) {
                            Number value = axisModel.getValue(r);
                            if (value != null) {
                                v[c] = axisModel.getNormalized(value.doubleValue());
                            } else {
                                v[c] = Double.NaN;
                                missing = true;
                            }
                            ++c;
                        }
                        if (missing) continue;
                        values.add(new High_DPoint(r, SwingClustering.this.factory.getDataFrame().getRowAddress(r), v));
                    }
                }
                try {
                    List clusters = settingsPanel.createClusterer(values.size()).cluster(values);
                    final HashMap<Object, HighD_Cluster> rowCluster = new HashMap<Object, HighD_Cluster>();
                    SwingClustering.this.listModel = new DefaultListModel();
                    int clusterId = 1;
                    for (Cluster cluster : clusters) {
                        HighD_Cluster highDCluster = new HighD_Cluster(clusterId, cluster);
                        SwingClustering.this.listModel.addElement(highDCluster);
                        ++clusterId;
                        List points = highDCluster.getCluster().getPoints();
                        for (High_DPoint point : points) {
                            rowCluster.put(point.getRow(), highDCluster);
                        }
                    }
                    SwingClustering.this.binningDimension.setBinningStrategy(new SingleBinningDimension.SingleBinningStrategy(){

                        public boolean isBinnable(Object o) {
                            return rowCluster.get(o) != null;
                        }

                        public Object rowToBin(Object o) {
                            return rowCluster.get(o);
                        }
                    });
                    SwingClustering.this.list.setModel(SwingClustering.this.listModel);
                }
                catch (Exception e1) {
                    Logging.getInstance().process((Throwable)e1);
                }
            }
        });
        controls.add((Component)clusterButton, "South");
        this.add((Component)controls, "North");
        this.add(this.list, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (HighD_Cluster cluster : SwingClustering.this.list.getSelectedValuesList()) {
                    List rows = cluster.getCluster().getPoints();
                    for (High_DPoint integer : rows) {
                        row.add(integer.getRow());
                    }
                }
                SwingClustering.this.factory.getVisual().getSelection().setSelectedIterable(row);
            }
        });
    }

    public void setModel(HighDFactory factory, SingleBinningDimension<Row, ?> model) {
        this.factory = factory;
        if (factory != null) {
            this.binningDimension = model;
            DefaultSwingCategoricalFilterComponent filter = new DefaultSwingCategoricalFilterComponent(this.binningDimension, factory.getVisual(), null);
            filter.getNullLabel().setValue((Object)"Unclustered");
            filter.getOrientation().setValue((Object)CategoricalFilterComponent.Orientation.Horizontal);
            filter.setInteractionMode(factory.getInteractionMode());
            filter.setColorTheme(factory.getColorTheme());
            this.add((Component)filter.getNativeComponent(), "Center");
        } else {
            this.removeAll();
        }
    }

    public JComponent getNativeComponent() {
        return this;
    }
}

