/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.view.regression;

import com.macrofocus.application.high_d.view.regression.RegressionSettingsPanel;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.clustering.HighD_Cluster;
import com.macrofocus.high_d.clustering.High_DPoint;
import com.macrofocus.high_d.regression.Regression;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.NumberDataFrame;
import com.macrofocus.molap.dataframe.matrix.CacheMatrix;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.molap.dataframe.matrix.vector.Vector;
import com.macrofocus.molap.dataframe.matrix.vector.VectorHelper;
import com.macrofocus.molap.subset.SubsetDataFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SwingRegression<Row, Column>
extends JPanel
implements Regression<JComponent, Color, Row, Column> {
    final JList<HighD_Cluster<Row>> list = new JList();
    private DefaultListModel<HighD_Cluster<Row>> listModel;
    private HighDFactory<JComponent, Color, Font, ?, Row, Column, Object> factory;

    public SwingRegression() {
        this.setLayout(new BorderLayout());
        JPanel controls = new JPanel(new BorderLayout());
        final RegressionSettingsPanel settingsPanel = new RegressionSettingsPanel();
        controls.add((Component)settingsPanel.getMainPanel(), "North");
        JButton clusterButton = new JButton(new AbstractAction("Create Regression"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList values = new ArrayList();
                for (AxisGroupModel group : SwingRegression.this.factory.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
                    for (Object r : SwingRegression.this.factory.getDataFrame().rows()) {
                        if (SwingRegression.this.factory.getVisual().getFilter().isFiltered(r)) continue;
                        double[] v = new double[group.getAxisOrder().size()];
                        int c = 0;
                        boolean missing = false;
                        for (AxisModel axisModel : group.getAxisOrder()) {
                            Number value = axisModel.getValue(r);
                            if (value != null) {
                                v[c] = axisModel.getNormalized(value.doubleValue());
                            } else {
                                v[c] = Double.NaN;
                                missing = true;
                            }
                            ++c;
                        }
                        if (missing) continue;
                    }
                }
                try {
                    SubsetDataFrame subsetDataFrame = SwingRegression.this.factory.getSubsetDataFrame();
                    NumberDataFrame matrix = new NumberDataFrame((DataFrame)subsetDataFrame);
                    Object yKey = matrix.getColumnKey(0);
                    Vector y = new CacheMatrix((Matrix)matrix).getColumnVector(yKey);
                    CacheMatrix x = new CacheMatrix((Matrix)new NumberDataFrame(subsetDataFrame.removeColumns(new Object[]{yKey})));
                    System.err.println(x.getRowCount() + "x" + x.getColumnCount());
                    System.err.println(y.size());
                    double[][] data = x.getData();
                    double[] dep = VectorHelper.getData((Vector)y);
                    settingsPanel.createRegresser().regress(data, dep);
                    HashMap rowCluster = new HashMap();
                    SwingRegression.this.listModel = new DefaultListModel();
                    SwingRegression.this.list.setModel(SwingRegression.this.listModel);
                }
                catch (Exception e1) {
                    Logging.getInstance().process((Throwable)e1);
                }
            }
        });
        controls.add((Component)clusterButton, "South");
        this.add((Component)controls, "North");
        this.add(this.list, "Center");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (HighD_Cluster cluster : SwingRegression.this.list.getSelectedValuesList()) {
                    List rows = cluster.getCluster().getPoints();
                    for (High_DPoint integer : rows) {
                        row.add(integer.getRow());
                    }
                }
                SwingRegression.this.factory.getVisual().getSelection().setSelectedIterable(row);
            }
        });
    }

    public void setModel(HighDFactory factory) {
        this.factory = factory;
        if (factory == null) {
            this.removeAll();
        }
    }

    public JComponent getNativeComponent() {
        return this;
    }
}

