/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.view.table;

import com.jidesoft.grid.AutoResizePopupMenuCustomizer;
import com.jidesoft.grid.RolloverTableUtils;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnChooserPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.CornerScroller;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.TableSearchable;
import com.macrofocus.application.high_d.view.table.FilterableTableSelectionCoordinator;
import com.macrofocus.application.high_d.view.table.RowStripeNavigationSortableTable;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.molap.dataframe.DataFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class TablePanel<Row>
extends JPanel {
    private final RowStripeNavigationSortableTable table;
    private DataFrame<Row, ?, ?> dataFrame;
    private TableModel tableModel;
    private MutableSingleSelection<Row> probing;
    private Thread autoSizeAllThread;
    private final SingleSelectionListener<Row> probingListener = new SingleSelectionListener<Row>(){

        public void selectionChanged(SingleSelectionEvent<Row> rowSingleSelectionEvent) {
            TablePanel.this.updateTableRollover();
        }
    };
    private final MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
            TablePanel.this.updateProbing();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TablePanel.this.updateProbing();
        }
    };

    public TablePanel() {
        this.table = new RowStripeNavigationSortableTable();
        JideScrollPane scrollPane = new JideScrollPane((Component)((Object)this.table));
        scrollPane.setVerticalScrollBarPolicy(22);
        this.table.setShowHorizontalLines(false);
        this.table.setAutoResizeMode(0);
        this.table.setColumnResizable(true);
        this.table.setColumnAutoResizable(true);
        this.table.setAutoscrolls(true);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setExpandIconVisible(true);
        this.table.setSelectionBackground(Color.red);
        TableSearchable tableSearchable = new TableSearchable((JTable)((Object)this.table));
        tableSearchable.setMainIndex(-1);
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)((Object)this.table));
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new AutoResizePopupMenuCustomizer());
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new TableColumnChooserPopupMenuCustomizer());
        AbstractButton tableColumnChooserButton = TableColumnChooser.getTableColumnChooserButton((JTable)((Object)this.table));
        tableColumnChooserButton.setContentAreaFilled(false);
        scrollPane.setCorner("UPPER_RIGHT_CORNER", (Component)tableColumnChooserButton);
        CornerScroller scroller = new CornerScroller((JScrollPane)scrollPane);
        scroller.setSelectionBorderColor(Color.GRAY);
        scrollPane.setCorner("LOWER_RIGHT_CORNER", (Component)scroller);
        this.setLayout(new OverlayLayout(this));
        this.add((Component)scrollPane);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction("Expand All"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        popupMenu.add(new AbstractAction("Expand First Level"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        popupMenu.add(new AbstractAction("Collapse All"){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.table.setComponentPopupMenu(popupMenu);
        RolloverTableUtils.install((JTable)((Object)this.table));
    }

    public void setModel(DataFrame dataFrame, TableModel tableModel, MutableSingleSelection<Row> probing, MutableSelection<Row> selection) {
        this.dataFrame = dataFrame;
        if (this.tableModel != null) {
            this.probing.removeSingleSelectionListener(this.probingListener);
            this.table.removeMouseMotionListener(this.mouseMotionListener);
        }
        this.tableModel = tableModel;
        this.probing = probing;
        probing.addSingleSelectionListener(this.probingListener);
        this.table.addMouseMotionListener(this.mouseMotionListener);
        TableModel oldTableModel = this.table.getModel();
        this.table.setModel(tableModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablePanel.this.autoSize();
            }
        });
        new FilterableTableSelectionCoordinator<Row>(dataFrame, (SortableTable)this.table, this.table.getSelectionModel(), selection);
    }

    private void autoSize() {
        if (this.autoSizeAllThread != null) {
            this.autoSizeAllThread.interrupt();
        }
        this.autoSizeAllThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int[] minimumWidth = new int[TablePanel.this.table.getColumnCount()];
                Arrays.fill(minimumWidth, 20);
                int[] maximumWidth = new int[TablePanel.this.table.getColumnCount()];
                Arrays.fill(maximumWidth, 150);
                TableUtils.autoResizeAllColumns((JTable)((Object)TablePanel.this.table), (int[])minimumWidth, (int[])maximumWidth, (boolean)true, (boolean)true, (boolean)true);
            }
        });
        this.autoSizeAllThread.start();
    }

    private void updateTableRollover() {
        Object probed;
        int found = -1;
        if (this.probing.isActive() && (probed = this.probing.getSelected()) != null) {
            found = TableModelWrapperUtils.getRowAt((TableModel)this.table.getModel(), (int)this.dataFrame.getRowAddress(probed));
        }
        this.table.setNavigationRolloverRow(found);
    }

    private void updateProbing() {
        int row = this.table.getNavigationRolloverRow();
        if (row >= 0) {
            int actualRow = TableModelWrapperUtils.getActualRowAt((TableModel)this.table.getModel(), (int)row);
            Object r = this.dataFrame.getRowKey(actualRow);
            this.probing.setSelected(r);
        } else {
            this.probing.clearSelection();
        }
    }

    public JTable getTable() {
        return this.table;
    }
}

