/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.exception;

import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class PureQueryWarning {
    private String rawMessage_;
    private String message_;
    private int exceptionLocation_;
    private String productVersion_;
    private ASTNode node_;
    private MethodInfo methodInfo_;
    private Throwable cause_;
    private static final int intNotSet_ = -1;
    private int lineNumber_ = -1;
    private int length_ = -1;
    private int columnNumber_ = -1;
    private int startPosition_ = -1;
    protected String methodName_ = null;
    protected static final String messageDelimiter_ = ";  ";
    private static final String productNameAbbreviation_ = "pdq";

    protected PureQueryWarning(String string, int n2, String string2, ASTNode aSTNode, MethodInfo methodInfo) {
        this(string, null, n2, string2, aSTNode, methodInfo);
    }

    protected PureQueryWarning(String string, Throwable throwable, int n2, String string2, ASTNode aSTNode, MethodInfo methodInfo) {
        this.rawMessage_ = string;
        this.exceptionLocation_ = n2;
        this.productVersion_ = string2;
        this.node_ = aSTNode;
        this.methodInfo_ = methodInfo;
        this.cause_ = throwable;
        if (this.node_ != null) {
            this.lineNumber_ = this.getNodeLineNumber(this.node_);
            this.columnNumber_ = this.getNodeColumnNumber(this.node_);
            this.startPosition_ = this.node_.getStartPosition();
            this.length_ = this.node_.getLength();
            this.methodName_ = null;
        } else if (this.methodInfo_ != null) {
            this.lineNumber_ = this.methodInfo_.getLineNumber();
            this.columnNumber_ = this.methodInfo_.getColumn();
            this.startPosition_ = this.methodInfo_.getStartPosition();
            this.length_ = this.methodInfo_.getLength();
            this.methodName_ = this.methodInfo_.getMethodNameAndParameterTypesString();
        }
    }

    public String getMessage() {
        if (null == this.message_) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(PureQueryWarning.formatMessage(this.exceptionLocation_, this.productVersion_, this.rawMessage_));
            if (-1 != this.lineNumber_) {
                stringBuilder.append(";  Line number: " + this.lineNumber_);
            }
            if (-1 != this.columnNumber_) {
                stringBuilder.append(";  Column number: " + this.columnNumber_);
            }
            if (null != this.methodName_ && 0 < this.methodName_.length()) {
                stringBuilder.append(";  Method name: " + this.methodName_);
            }
            this.message_ = stringBuilder.toString();
        }
        return this.message_;
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    public int getColumnNumber() {
        return this.columnNumber_;
    }

    public int getStartPosition() {
        return this.startPosition_;
    }

    public int getLength() {
        return this.length_;
    }

    public Throwable getCause() {
        return this.cause_;
    }

    protected static String formatMessage(int n2, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        } else if (0 < stringBuilder.length()) {
            stringBuilder.append('\n');
        }
        stringBuilder.append('[').append(productNameAbbreviation_).append(']');
        stringBuilder.append('[').append(n2).append(']');
        stringBuilder.append('[').append(string).append(']');
        stringBuilder.append(' ');
        if (null != string2) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private int getNodeLineNumber(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (aSTNode2 != null && aSTNode2.getNodeType() == 15) {
            CompilationUnit compilationUnit = (CompilationUnit)aSTNode2;
            return compilationUnit.getLineNumber(aSTNode.getStartPosition());
        }
        return -1;
    }

    private int getNodeColumnNumber(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getRoot();
        if (aSTNode2 != null && aSTNode2.getNodeType() == 15) {
            CompilationUnit compilationUnit = (CompilationUnit)aSTNode2;
            return compilationUnit.getColumnNumber(aSTNode.getStartPosition());
        }
        return -1;
    }
}

